/**
 * Demonstrates a NestedList, which uses a TreeStore to drill down through hierarchical data
 */
Ext.require('Ext.data.TreeStore', function() {
    Ext.define('Kitchensink.view.windowsphone.NestedList', {
        requires: ['Kitchensink.view.windowsphone.EditorPanel', 'Kitchensink.model.Cars', 'Ext.layout.Fit'],
        extend: 'Ext.Container',
        config: {
            layout: 'fit',
            items: [{
                xtype: 'nestedlist',
                store: {
                    type: 'tree',
                    id: 'NestedListStore',
                    model: 'Kitchensink.model.Cars',
                    root: {},
                    proxy: {
                        type: 'ajax',
                        //url: 'http://dev.sencha.com/deploy/touch/examples/production/kitchensink/carregions.json'
                        url: 'carregions.json'
                    }
                },
                displayField: 'text',
                listeners: {
                    leafitemtap: function(me, list, index, item) {
                        var editorPanel = Ext.getCmp('editorPanel') || new Kitchensink.view.windowsphone.EditorPanel();
                        editorPanel.setRecord(list.getStore().getAt(index));
                        if (!editorPanel.getParent()) {
                            Ext.Viewport.add(editorPanel);
                        }
                        editorPanel.show();
                    }
                }
            }]
        }
    });
});
